/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.util.interaction;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.recipes.knapping.KnappingType;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.objects.blocks.BlockCharcoalPile;
import net.dries007.tfc.objects.blocks.BlocksTFC;
import net.dries007.tfc.objects.te.TELogPile;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.dries007.tfc.util.interaction.ClientInteractionManager;
import net.dries007.tfc.util.interaction.IRightClickBlockAction;
import net.dries007.tfc.util.interaction.IRightClickItemAction;
import net.dries007.tfc.util.interaction.ServerInteractionManager;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="tfc")
public final class InteractionManager {
    private static final Map<Predicate<ItemStack>, IRightClickBlockAction> USE_ACTIONS = new HashMap<Predicate<ItemStack>, IRightClickBlockAction>();
    private static final Map<Predicate<ItemStack>, IRightClickItemAction> RIGHT_CLICK_ACTIONS = new HashMap<Predicate<ItemStack>, IRightClickItemAction>();
    private static final ThreadLocal<Boolean> PROCESSING_INTERACTION = ThreadLocal.withInitial(() -> false);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!PROCESSING_INTERACTION.get().booleanValue()) {
            PROCESSING_INTERACTION.set(true);
            IRightClickBlockAction action = InteractionManager.findItemUseAction(event.getItemStack());
            if (action != null) {
                EnumActionResult result = event.getSide() == Side.CLIENT ? ClientInteractionManager.processRightClickBlock(event, action) : ServerInteractionManager.processRightClickBlock(event, action);
                event.setCancellationResult(result);
                event.setCanceled(true);
            }
            PROCESSING_INTERACTION.set(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        IRightClickItemAction action = InteractionManager.findItemRightClickAction(event.getItemStack());
        if (action != null) {
            EnumActionResult result = event.getSide() == Side.CLIENT ? ClientInteractionManager.processRightClickItem(event, action) : ServerInteractionManager.processRightClickItem(event, action);
            event.setCancellationResult(result);
            event.setCanceled(true);
        }
    }

    @Nullable
    private static IRightClickBlockAction findItemUseAction(ItemStack stack) {
        return USE_ACTIONS.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(stack)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    @Nullable
    private static IRightClickItemAction findItemRightClickAction(ItemStack stack) {
        return RIGHT_CLICK_ACTIONS.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(stack)).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    private static void putBoth(Predicate<ItemStack> predicate, IRightClickItemAction minorAction) {
        USE_ACTIONS.put(predicate, minorAction);
        RIGHT_CLICK_ACTIONS.put(predicate, minorAction);
    }

    static {
        InteractionManager.putBoth(stack -> OreDictionaryHelper.doesStackMatchOre(stack, "clay") && stack.func_190916_E() >= KnappingType.CLAY.getAmountToConsume(), (worldIn, playerIn, handIn) -> {
            if (!worldIn.field_72995_K) {
                TFCGuiHandler.openGui(worldIn, playerIn, TFCGuiHandler.Type.KNAPPING_CLAY);
            }
            return EnumActionResult.SUCCESS;
        });
        InteractionManager.putBoth(stack -> OreDictionaryHelper.doesStackMatchOre(stack, "fireClay") && stack.func_190916_E() >= KnappingType.FIRE_CLAY.getAmountToConsume(), (worldIn, playerIn, handIn) -> {
            if (!worldIn.field_72995_K) {
                TFCGuiHandler.openGui(worldIn, playerIn, TFCGuiHandler.Type.KNAPPING_FIRE_CLAY);
            }
            return EnumActionResult.SUCCESS;
        });
        InteractionManager.putBoth(stack -> OreDictionaryHelper.doesStackMatchOre(stack, "leather"), (worldIn, playerIn, handIn) -> {
            if (Helpers.playerHasItemMatchingOre(playerIn.field_71071_by, "knife")) {
                if (!worldIn.field_72995_K) {
                    TFCGuiHandler.openGui(worldIn, playerIn, TFCGuiHandler.Type.KNAPPING_LEATHER);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        });
        InteractionManager.putBoth(stack -> OreDictionaryHelper.doesStackMatchOre(stack, "bowl"), (worldIn, playerIn, handIn) -> {
            if (OreDictionaryHelper.doesStackMatchOre(playerIn.func_184586_b(handIn == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND), "knife")) {
                if (!worldIn.field_72995_K) {
                    TFCGuiHandler.openGui(worldIn, playerIn, TFCGuiHandler.Type.SALAD);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        });
        USE_ACTIONS.put(stack -> OreDictionaryHelper.doesStackMatchOre(stack, "logWood"), (stack, player, worldIn, pos, hand, direction, hitX, hitY, hitZ) -> {
            if (direction != null) {
                TELogPile te;
                IBlockState stateAt = worldIn.func_180495_p(pos);
                if (stateAt.func_177230_c() == BlocksTFC.LOG_PILE && (te = Helpers.getTE((IBlockAccess)worldIn, pos, TELogPile.class)) != null) {
                    if (!player.func_70093_af()) {
                        if (te.insertLog(stack)) {
                            if (!worldIn.field_72995_K) {
                                worldIn.func_184133_a(null, pos.func_177972_a(direction), SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                stack.func_190918_g(1);
                                player.func_184611_a(hand, stack);
                            }
                            return EnumActionResult.SUCCESS;
                        }
                    } else {
                        int inserted = te.insertLogs(stack.func_77946_l());
                        if (inserted > 0) {
                            if (!worldIn.field_72995_K) {
                                worldIn.func_184133_a(null, pos.func_177972_a(direction), SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                                stack.func_190918_g(inserted);
                                player.func_184611_a(hand, stack);
                            }
                            return EnumActionResult.SUCCESS;
                        }
                    }
                }
                if (ConfigTFC.General.OVERRIDES.enableLogPiles && player.func_70093_af()) {
                    BlockPos posAt = pos;
                    if (!stateAt.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
                        posAt = posAt.func_177972_a(direction);
                    }
                    if (worldIn.func_180495_p(posAt.func_177977_b()).func_185915_l() && worldIn.func_190527_a((Block)BlocksTFC.LOG_PILE, posAt, false, direction, null)) {
                        if (!worldIn.field_72995_K) {
                            worldIn.func_175656_a(posAt, BlocksTFC.LOG_PILE.func_180642_a(worldIn, posAt, direction, 0.0f, 0.0f, 0.0f, 0, (EntityLivingBase)player));
                            TELogPile te2 = Helpers.getTE((IBlockAccess)worldIn, posAt, TELogPile.class);
                            if (te2 != null) {
                                te2.insertLog(stack.func_77946_l());
                            }
                            worldIn.func_184133_a(null, posAt, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                            stack.func_190918_g(1);
                            player.func_184611_a(hand, stack);
                        }
                        return EnumActionResult.SUCCESS;
                    }
                }
            }
            return EnumActionResult.PASS;
        });
        USE_ACTIONS.put(stack -> OreDictionaryHelper.doesStackMatchOre(stack, "charcoal"), (stack, player, worldIn, pos, hand, direction, hitX, hitY, hitZ) -> {
            if (direction != null) {
                IBlockState stateToPlace;
                IBlockState stateToPlace2;
                IBlockState state = worldIn.func_180495_p(pos);
                if (state.func_177230_c() == BlocksTFC.CHARCOAL_PILE && (Integer)state.func_177229_b((IProperty)BlockCharcoalPile.LAYERS) < 8 && worldIn.func_72855_b((stateToPlace2 = state.func_177226_a((IProperty)BlockCharcoalPile.LAYERS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)BlockCharcoalPile.LAYERS) + 1))).func_185900_c((IBlockAccess)worldIn, pos).func_186670_a(pos))) {
                    if (!worldIn.field_72995_K) {
                        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)BlockCharcoalPile.LAYERS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)BlockCharcoalPile.LAYERS) + 1)));
                        worldIn.func_184133_a(null, pos, TFCSounds.CHARCOAL_PILE.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        stack.func_190918_g(1);
                        player.func_184611_a(hand, stack);
                    }
                    return EnumActionResult.SUCCESS;
                }
                BlockPos posAt = pos;
                if (!state.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
                    posAt = posAt.func_177972_a(direction);
                }
                if (worldIn.func_180495_p(posAt.func_177977_b()).isSideSolid((IBlockAccess)worldIn, posAt.func_177977_b(), EnumFacing.UP) && worldIn.func_180495_p(posAt).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.func_72855_b((stateToPlace = BlocksTFC.CHARCOAL_PILE.func_176223_P().func_177226_a((IProperty)BlockCharcoalPile.LAYERS, (Comparable)Integer.valueOf(1))).func_185900_c((IBlockAccess)worldIn, posAt).func_186670_a(posAt))) {
                    if (!worldIn.field_72995_K) {
                        worldIn.func_175656_a(posAt, stateToPlace);
                        worldIn.func_184133_a(null, posAt, TFCSounds.CHARCOAL_PILE.func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        stack.func_190918_g(1);
                        player.func_184611_a(hand, stack);
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
            return EnumActionResult.FAIL;
        });
    }
}

